<?php
require_once 'config/config.php';
require_once 'config/session.php';
require_once 'config/auth.php';
require_once 'config/roles.php';

// Cek login
if (!isLogin()) {
    header("Location: login.php");
    exit;
}

// Tentukan halaman
$page = $_GET['page'] ?? 'dashboard';
$module = $_GET['module'] ?? 'dashboard';

// Validasi role
if (!hasAccess($module)) {
    echo "Akses ditolak!";
    exit;
}

// Tentukan file modul
$path = "modules/$module/index.php";

if (!file_exists($path)) {
    echo "Halaman tidak ditemukan";
    exit;
}

// Load layout
$title = ucfirst($module);
$content = $path;

include 'templates/layout.php';
